# 帳票設計書 13-DevOps Report

## 概要

本ドキュメントは、GitLabにおけるDevOps Report機能の帳票設計書である。インスタンス全体のDevOps採用状況を画面表示するレポート機能について、表示内容、データ構造、処理フローを定義する。

### 本帳票の処理概要

DevOps Reportは、GitLabインスタンス全体のDevOps成熟度を可視化するダッシュボード画面である。Issue、Merge Request、CI/CDパイプライン、デプロイメントなどの各DevOpsプラクティスの採用状況をスコア化し、業界リーダーとの比較を表示する。

**業務上の目的・背景**：組織のDevOps成熟度を客観的に評価し、改善ポイントを特定する必要がある。このレポートにより、GitLabの各機能がどの程度活用されているかを把握し、DevOpsプラクティスの導入・改善に向けた意思決定を支援する。Conversational Development Index（CDI）の概念に基づき、開発プロセス全体の効率を測定する。

**帳票の利用シーン**：管理者が組織全体のDevOps採用状況を確認する場合、DevOps変革プロジェクトの進捗を追跡する場合、経営層への報告資料として利用する場合、チーム間のDevOps成熟度を比較分析する場合などで利用される。

**主要な出力内容**：
1. DevOpsスコアカード（Issues、Comments、Milestones、Boards、Merge Requests、Pipelines、Environments、Deployments、Service Desk）
2. 各カテゴリのインスタンススコア vs リーダースコア
3. パーセンテージスコア（リーダー比）
4. Idea to Production ステップ別スコア
5. 平均パーセンテージスコア

**帳票の出力タイミング**：管理者画面のDevOps Reportページにアクセスした際に表示される。データは定期的に収集・更新される。

**帳票の利用者**：システム管理者、DevOps推進担当者、経営層

## 帳票種別

画面表示（ダッシュボード）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | DevOps Report | `/admin/dev_ops_report` | 画面アクセス |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | HTML（画面表示） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A |
| 出力方法 | 画面表示 |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

画面構成

```
┌─────────────────────────────────────┐
│           DevOps Report             │
├─────────────────────────────────────┤
│    平均スコア: XX.X%                 │
├─────────────────────────────────────┤
│  ┌─────────────────────────────┐   │
│  │      スコアカード一覧         │   │
│  │  Issues | Comments | ...     │   │
│  │  [スコアバー]                │   │
│  └─────────────────────────────┘   │
├─────────────────────────────────────┤
│  ┌─────────────────────────────┐   │
│  │   Idea to Production        │   │
│  │   Idea → Issue → Plan → ... │   │
│  └─────────────────────────────┘   │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | レポートタイトル | "DevOps Report" | 固定値 | 文字列 |
| 2 | 平均スコア | 全カテゴリの平均パーセンテージ | 計算値 | パーセント |
| 3 | 最終更新日時 | メトリクス取得日時 | conversational_development_index_metrics.created_at | 日時 |

### 明細部（スコアカード）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Issues | Issue作成数/アクティブユーザー | instance_issues, leader_issues, percentage_issues | スコアカード |
| 2 | Comments | コメント作成数/アクティブユーザー | instance_notes, leader_notes, percentage_notes | スコアカード |
| 3 | Milestones | マイルストーン作成数/アクティブユーザー | instance_milestones, leader_milestones, percentage_milestones | スコアカード |
| 4 | Boards | ボード作成数/アクティブユーザー | instance_boards, leader_boards, percentage_boards | スコアカード |
| 5 | Merge Requests | MR作成数/アクティブユーザー | instance_merge_requests, leader_merge_requests, percentage_merge_requests | スコアカード |
| 6 | Pipelines | パイプライン作成数/アクティブユーザー | instance_ci_pipelines, leader_ci_pipelines, percentage_ci_pipelines | スコアカード |
| 7 | Environments | 環境作成数/アクティブユーザー | instance_environments, leader_environments, percentage_environments | スコアカード |
| 8 | Deployments | デプロイ数/アクティブユーザー | instance_deployments, leader_deployments, percentage_deployments | スコアカード |
| 9 | Service Desk | Service Desk Issue数/アクティブユーザー | instance_service_desk_issues, leader_service_desk_issues, percentage_service_desk_issues | スコアカード |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | ドキュメントリンク | 各カテゴリのヘルプドキュメント | 固定URL | リンク |
| 2 | ブログリンク | 関連するベストプラクティス記事 | 固定URL | リンク |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 管理者権限 | 管理者画面へのアクセス権限 | Yes |
| メトリクスデータ存在 | DevOpsメトリクスが収集済み | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | メトリクス作成日時 | 降順（最新） |

### 改ページ条件

N/A（単一画面）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| conversational_development_index_metrics | DevOpsメトリクス | 最新レコード |

### テーブル別参照項目詳細

#### conversational_development_index_metrics

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| leader_issues | リーダースコア（Issues） | ORDER BY created_at DESC LIMIT 1 | - |
| instance_issues | インスタンススコア（Issues） | 同上 | - |
| percentage_issues | パーセンテージ（Issues） | 同上 | - |
| leader_notes | リーダースコア（Comments） | 同上 | - |
| instance_notes | インスタンススコア（Comments） | 同上 | - |
| percentage_notes | パーセンテージ（Comments） | 同上 | - |
| leader_milestones | リーダースコア（Milestones） | 同上 | - |
| instance_milestones | インスタンススコア（Milestones） | 同上 | - |
| percentage_milestones | パーセンテージ（Milestones） | 同上 | - |
| leader_boards | リーダースコア（Boards） | 同上 | - |
| instance_boards | インスタンススコア（Boards） | 同上 | - |
| percentage_boards | パーセンテージ（Boards） | 同上 | - |
| leader_merge_requests | リーダースコア（MR） | 同上 | - |
| instance_merge_requests | インスタンススコア（MR） | 同上 | - |
| percentage_merge_requests | パーセンテージ（MR） | 同上 | - |
| leader_ci_pipelines | リーダースコア（Pipelines） | 同上 | - |
| instance_ci_pipelines | インスタンススコア（Pipelines） | 同上 | - |
| percentage_ci_pipelines | パーセンテージ（Pipelines） | 同上 | - |
| leader_environments | リーダースコア（Environments） | 同上 | - |
| instance_environments | インスタンススコア（Environments） | 同上 | - |
| percentage_environments | パーセンテージ（Environments） | 同上 | - |
| leader_deployments | リーダースコア（Deployments） | 同上 | - |
| instance_deployments | インスタンススコア（Deployments） | 同上 | - |
| percentage_deployments | パーセンテージ（Deployments） | 同上 | - |
| leader_service_desk_issues | リーダースコア（Service Desk） | 同上 | - |
| instance_service_desk_issues | インスタンススコア（Service Desk） | 同上 | - |
| percentage_service_desk_issues | パーセンテージ（Service Desk） | 同上 | - |
| created_at | 最終更新日時 | 同上 | - |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 平均パーセンテージスコア | 全カテゴリのpercentage_*の合計 / カテゴリ数 | 小数点以下1桁 | cards.sum(&:percentage_score) / cards.size |
| Idea to Productionステップスコア | 関連機能のパーセンテージ平均 | 小数点以下1桁 | 複数機能の平均 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[画面アクセス] --> B[管理者権限チェック]
    B -->|権限あり| C[最新メトリクス取得]
    B -->|権限なし| Z[アクセス拒否]
    C --> D{メトリクス存在?}
    D -->|Yes| E[MetricPresenterで整形]
    D -->|No| F[データなしメッセージ表示]
    E --> G[スコアカード生成]
    G --> H[Idea to Productionステップ生成]
    H --> I[画面表示]
    F --> I
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | メトリクスが未収集 | No data available | メトリクス収集ジョブの実行を確認 |
| 権限エラー | 管理者権限がない | Access denied | 管理者権限を取得する |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1レコード（最新のメトリクス） |
| 目標出力時間 | 1秒以内 |
| 同時アクセス数上限 | 特になし |

## セキュリティ考慮事項

- 管理者画面のため、管理者権限を持つユーザーのみアクセス可能
- インスタンス全体の統計情報のため、個別プロジェクトの詳細は含まれない
- 内部イベントトラッキング（i_analytics_dev_ops_score）で利用状況を記録

## 備考

- メトリクスデータは定期的なバックグラウンドジョブで収集される
- リーダースコアはGitLab社が収集した業界標準値
- EE版では追加の分析機能（Adoption）が利用可能

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

DevOpsメトリクスのデータモデルを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | metric.rb | `app/models/dev_ops_report/metric.rb` | メトリクスモデル。METRICS定数で全メトリクス項目を定義 |

**読解のコツ**: METRICSの配列で定義されている項目が画面に表示されるスコアカードに対応。leader_*, instance_*, percentage_*の3種類がセットになっている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | dev_ops_report_controller.rb | `app/controllers/admin/dev_ops_report_controller.rb` | コントローラ。show アクションがエントリーポイント |

**主要処理フロー**:
1. **18-20行目**: showアクション - 最新のMetricを取得してpresent
2. **8-11行目**: track_internal_event - 利用状況のトラッキング
3. **13行目**: feature_category :devops_reports - 機能カテゴリ指定

#### Step 3: プレゼンター層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | metric_presenter.rb | `app/presenters/dev_ops_report/metric_presenter.rb` | スコアカードとIdea to Productionステップの生成 |

**主要処理フロー**:
- **9-81行目**: cardsメソッド - 9種類のスコアカードを定義
- **83-136行目**: idea_to_production_stepsメソッド - 10ステップを定義
- **138-140行目**: average_percentage_scoreメソッド - 平均スコア計算

### プログラム呼び出し階層図

```
Admin::DevOpsReportController#show
    │
    ├─ DevOpsReport::Metric.order(:created_at).last
    │      └─ 最新のメトリクスレコード取得
    │
    └─ .present
           └─ DevOpsReport::MetricPresenter
                  ├─ cards (9種類のCard生成)
                  │      ├─ Card.new(Issues)
                  │      ├─ Card.new(Comments)
                  │      ├─ Card.new(Milestones)
                  │      ├─ Card.new(Boards)
                  │      ├─ Card.new(Merge Requests)
                  │      ├─ Card.new(Pipelines)
                  │      ├─ Card.new(Environments)
                  │      ├─ Card.new(Deployments)
                  │      └─ Card.new(Service Desk)
                  │
                  ├─ idea_to_production_steps (10ステップ)
                  │      ├─ IdeaToProductionStep.new(Idea)
                  │      ├─ IdeaToProductionStep.new(Issue)
                  │      ├─ IdeaToProductionStep.new(Plan)
                  │      ├─ IdeaToProductionStep.new(Code)
                  │      ├─ IdeaToProductionStep.new(Commit)
                  │      ├─ IdeaToProductionStep.new(Test)
                  │      ├─ IdeaToProductionStep.new(Review)
                  │      ├─ IdeaToProductionStep.new(Staging)
                  │      ├─ IdeaToProductionStep.new(Production)
                  │      └─ IdeaToProductionStep.new(Feedback)
                  │
                  └─ average_percentage_score
```

### データフロー図

```
[入力]                    [処理]                         [出力]

conversational_         ─▶ DevOpsReport::Metric ────▶ MetricPresenter
development_index_         (モデル)                     (プレゼンター)
metrics テーブル                                            │
                                                           ├─▶ cards (スコアカード)
                                                           │     └─ Card×9
                                                           │
                                                           ├─▶ idea_to_production_steps
                                                           │     └─ Step×10
                                                           │
                                                           └─▶ average_percentage_score
                                                                 └─ 平均スコア
                                                                       ↓
                                                                 画面表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| dev_ops_report_controller.rb | `app/controllers/admin/dev_ops_report_controller.rb` | ソース | コントローラ |
| metric.rb | `app/models/dev_ops_report/metric.rb` | ソース | メトリクスモデル |
| metric_presenter.rb | `app/presenters/dev_ops_report/metric_presenter.rb` | ソース | プレゼンター |
| card.rb | `app/presenters/dev_ops_report/card.rb` | ソース | スコアカード |
| idea_to_production_step.rb | `app/presenters/dev_ops_report/idea_to_production_step.rb` | ソース | I2Pステップ |
| show.html.haml | `app/views/admin/dev_ops_report/show.html.haml` | テンプレート | 画面テンプレート |
